let data = null;
let universities = null;
let subjects = new Set();
let series = null;
let data_file = './data/Rank.csv';

function get_subjects(data){
    data.forEach(d => {
        subjects.add(d['SubjectName']);
    })
}

function load_data(data){
    universities = {};
    data.forEach(d => {
        let u = d['SchoolName'];
        let s = d['SubjectName'];
        let r = parseInt(d['SubjectRanking']);
        let v = parseFloat(d['SubjectScores']);
        if(!universities.hasOwnProperty(u)){
            universities[u] = {};
        }
        universities[u][s] = [r, v];
    });
}

function get_min_max(data, attr) {
    let min = 1e9;
    let max = 0;
    data.forEach(d => {
        let v = parseInt(d[attr]);
        if (v > max)
            max = v;
        if (v < min)
            min = v;
    });
    console.log('attr', attr, 'min', min, 'max', max);

    return [min, max];
}

function get_set(data, attr) {
    let set = [];
    data.forEach(d => {
        let v = d[attr];
        set.push(v);
    })

    return set;
}