let _width = $(window).width();
let _height = $(window).height();
let width = 0.9 * _width;
let height = 0.96 * _height;

let x_attr = 'SchoolName';
let fontFamily;

let colorlinear = d3.scaleLinear().domain([0, 100]).range([0, 1])
let interColor = d3.interpolate('red', 'green')


function color(entry){
    if(entry===undefined) return 'rgb(241, 241, 241)';
    let v = entry[1];
    if(v<=50){
        return `rgb(${255*v/50}, ${255}, 0)`
    }else{
        return `rgb(${255}, ${255*(100-v)/50}, 0)`
    }
}

function draw_main() {
    let padding = {'left': 0.2*width, 'bottom': 0.2*height, 'top': 0.2*height, 'right': 0.1*width};
    let svg = d3.select('#container')
        .select('svg')
        .attr('width', width)
        .attr('height', height);

    // title
    svg.append('g')
        .append('text')
        .attr('class', 'title')
        .attr('text-anchor', 'middle')
        .attr('transform', `translate(${padding.left+(width-padding.left-padding.right)/2}, ${padding.top*0.4})`)
        .text('Matrix Vis for subjects ranking of different universities')
        .attr('font-size', 30);

    // x axis - university
    let x_values = get_set(data, x_attr);
    let x = d3.scaleBand()
        .domain(x_values)
        .range([padding.left, width-padding.right])
        .paddingInner(0.1);    
    let axis_x = d3.axisBottom()
        .scale(x)
        .ticks(x_values.length)
        .tickFormat(d => d);

    // y axis - subjects
    let y_values = subjects;
    let y = d3.scaleBand()
        .domain(y_values)
        .range([height-padding.bottom, padding.top])
        .paddingInner(0.1);    
   
    let axis_y = d3.axisLeft()
        .scale(y)
        .ticks(y_values.length)
        .tickFormat(d => d);

    // x axis
    svg.append('g')
        .attr('transform', `translate(${0}, ${height-padding.bottom})`)
        .call(axis_x)
        .selectAll('text')
        .attr('font-family', fontFamily)
        .style('text-anchor', "start")
        .attr('transform', 'rotate(15)')
        .attr('font-size', 10);

    // y axis
    svg.append('g')        
        .attr('transform', `translate(${padding.left}, ${0})`)
        .call(axis_y)
        .attr('font-family', fontFamily)
        .attr('font-size', 10)
        .attr('text-anchor', 'end')

    let size_x = - x('Peking University') + x('Tsinghua University');
    let size_y = - y('Agricultural Sciences') + y('Space Science');

    let matrix = svg.append('g')

    let i = 0;
    let j = 0;
    for(let u in universities){
        j = 0;
        for(let s of subjects){
            matrix.append('rect')
                .attr('fill', ()=>{
                    return color(universities[u][s]);
                })
                .attr('stroke', 'black')
                .attr('stroke-width', 0.5)
                .attr('x', x(u))
                .attr('y', y(s))
                .attr('width', size_x)
                .attr('height', size_y)
            j+=1;
        }
        i+=1;
    }

    // color legend
    rect_width = width*0.3;
    rect_height = height*0.03;
    legend = svg.append('g')
        .attr('id', 'legend')
        .append('g')
        .attr('id', 'legendrect')
        .attr('transform', `translate(${width-padding.right-rect_width}, ${padding.top*0.5})`)

    legend.selectAll('#legendrect')
        .data(d3.range(100))
        .enter()
        .append('rect')
        .attr('width', rect_width/100)
        .attr('height', rect_height)
        .attr('x', (d, i)=>i*rect_width/100)
        .attr('y', 0)
        .attr('fill', (d, i)=>{
            return color([0, 100-i])
        })

    legend.append('text')
        .attr('x', 0)
        .attr('y', rect_height*2)
        .attr('text-anchor', 'middle')
        .attr('font-size', '15')
        .text('100');
    legend.append('text')
        .attr('x', rect_width)
        .attr('y', rect_height*2)
        .attr('text-anchor', 'middle')
        .attr('font-size', '15')
        .text('0');
}

function main() {
    d3.csv(data_file).then(function(DATA) {
        data = DATA;
        get_subjects(data);
        load_data(data);
        draw_main();
    })
}

main()