// 定义绘制区域大小
const width = 500;
const height = 500;

const padding = 50;

// 读取数据
d3.csv("../data/data.csv").then(data => {
    console.log("data", data);

    // 定义坐标轴变量
    const xAttr = "petal_width";
    const yAttr = "petal_length";

    // 定义坐标轴比例尺
    const xScale = d3.scaleLinear()
        .domain([0, Math.max(...data.map(d => d[xAttr]))])
        .range([padding, width - padding]);
    const yScale = d3.scaleLinear()
        .domain([0, Math.max(...data.map(d => d[yAttr]))])
        .range([height - padding, padding]);

    // 定义坐标轴
    const xAxis = d3.axisBottom()
        .scale(xScale)
        .ticks(8);
    const yAxis = d3.axisLeft()
        .scale(yScale)
        .ticks(8);

    // 绘图

    // 设置画布
    const svg = d3.select("#container")
        .append("svg")
        .attr("width", width)
        .attr("height", height);

    // 绘制坐标轴
    svg.append("g")
        .attr("transform", `translate(0, ${height - padding})`)
        .classed("x-axis", true)
        .call(xAxis);
    svg.append("g")
        .attr("transform", `translate(${padding}, 0)`)
        .classed("y-axis", true)
        .call(yAxis);

    // 绘制数据
    const elements = svg.selectAll(".element")
        .data(data)
        .enter()
        .append("circle")
        .classed("element", true)
        .attr("cx", d => xScale(d[xAttr]))
        .attr("cy", d => yScale(d[yAttr]))
        .attr("r", 5)
        .attr("fill", "red")
        .attr("fill-opacity", 0.5)
        .style("cursor", "pointer")
        .on("mouseenter", (e, datum) => {
            elements.filter(d => d === datum)
                .attr("stroke", "black")
                .attr("stroke-width", 1);
        })
        .on("mouseleave", (e, datum) => {
            elements
                .attr("stroke", null)
                .attr("stroke-width", 0);
        })

    // 绘制坐标轴标题
    const fontsize = 15;
    const xTitle = svg.append("text")
        .classed("x-title", true)
        .attr("x", width - padding)
        .attr("y", height - padding + fontsize * 1.6)
        .attr("font-size", fontsize)
        .attr("text-anchor", "middle")
        .attr("dy", "0.35em")
        .attr("fill", "black")
        .text(xAttr);

    const yTitle = svg.append("text")
        .classed("y-title", true)
        .attr("x", padding)
        .attr("y", padding - fontsize * 1.2)
        .attr("font-size", fontsize)
        .attr("text-anchor", "middle")
        .attr("dy", "0.35em")
        .attr("fill", "black")
        .text(yAttr);
})